<?php session_start(); require_once 'config.php'; ?><!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Team - Cleaning Service</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="assets/img/favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link
        href="../../css2-2?family=Fuzzy+Bubbles:wght@400;700&family=Poppins:wght@400;500;600;700;800&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/slick.min.css">
    <link rel="stylesheet" href="assets/css/animate.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
</head>

<body>
    
    </div><?php include 'header.php'; ?>
    <div class="breadcumb-wrapper " data-bg-src="assets/img/breadcumb/breadcumb-bg.png">
            <div class="container z-index-common">
                <div class="breadcumb-content">
                    <h1 class="breadcumb-title">meet our <span>team</span></h1>
                </div>
                <div class="breadcumb-menu-wrap">
                    <ul class="breadcumb-menu">
                        <li><a href="index.php">Home</a></li>
                        <li>our team member</li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- Team Area  -->
         <section class="team-layout2 space">
            <style>
                /* =====================================
   TEAM LAYOUT 2 – UNIQUE & RESPONSIVE
===================================== */

.team-layout2 {
    position: relative;
    padding: clamp(70px, 9vw, 160px) 0;
    overflow: hidden;
}

/* =====================================
   GRID REFINEMENT
===================================== */

.team-layout2 .row.g-5 {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: clamp(22px, 3vw, 40px);
}

.team-layout2 .row.g-5 > [class*="col-"] {
    width: 100% !important;
    max-width: 100% !important;
}

/* =====================================
   TEAM CARD
===================================== */

.vs-team__style1 {
    height: 100%;
    background: linear-gradient(180deg, #ffffff, #f8fafc);
    border-radius: 28px;
    padding: 18px;
    box-shadow: 
        0 20px 45px rgba(0,0,0,0.08),
        inset 0 0 0 1px rgba(255,255,255,0.7);
    transition: transform 0.4s ease, box-shadow 0.4s ease;
    position: relative;
}

.vs-team__style1:hover {
    transform: translateY(-14px);
    box-shadow: 0 45px 100px rgba(0,0,0,0.18);
}

/* =====================================
   IMAGE AREA
===================================== */

.vs-team__img {
    position: relative;
    border-radius: 22px;
    overflow: hidden;
    background: linear-gradient(135deg, #e0f2fe, #f8fafc);
}

.vs-team__img img {
    width: 100%;
    height: auto;
    object-fit: contain;
    transition: transform 0.6s ease;
}

.vs-team__style1:hover .vs-team__img img {
    transform: scale(1.08);
}

/* =====================================
   SOCIAL MEDIA OVERLAY
===================================== */

.vs-team__social--media {
    position: absolute;
    inset: 0;
    background: linear-gradient(
        to top,
        rgba(15,23,42,0.9),
        rgba(15,23,42,0.1)
    );
    display: flex;
    align-items: flex-end;
    justify-content: center;
    gap: 14px;
    padding-bottom: 22px;
    opacity: 0;
    transition: opacity 0.4s ease;
}

.vs-team__style1:hover .vs-team__social--media {
    opacity: 1;
}

.vs-team__social--media a {
    width: 40px;
    height: 40px;
    background: #ffffff;
    color: #0f172a;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
    transition: transform 0.3s ease, background 0.3s ease;
}

.vs-team__social--media a:hover {
    transform: translateY(-5px);
    background: #4facfe;
    color: #ffffff;
}

/* =====================================
   CONTENT
===================================== */

.vs-team__content {
    text-align: center;
    padding: 18px 6px 8px;
}

.vs-team__title a {
    font-size: clamp(17px, 1.6vw, 20px);
    font-weight: 800;
    color: #0f172a;
    text-decoration: none;
}

.vs-team__subtitle {
    font-size: 14px;
    color: #64748b;
    margin-top: 4px;
    text-transform: capitalize;
}

/* =====================================
   MOBILE OPTIMIZATION
===================================== */

@media (max-width: 576px) {

    .vs-team__style1 {
        padding: 16px;
    }

    .vs-team__social--media {
        padding-bottom: 18px;
    }

    .vs-team__social--media a {
        width: 36px;
        height: 36px;
        font-size: 13px;
    }
}

/* =====================================
   ULTRA WIDE SCREENS
===================================== */

@media (min-width: 1600px) {
    .team-layout2 {
        padding: 180px 0;
    }
}

            </style>
            <div class="container">
                <div class="row g-5">
                <?php
                // Fetch team members from database
                $query = "SELECT id, name, position, image FROM team_members WHERE status = 'active' ORDER BY created_at ASC";
                $result = $conn->query($query);

                // Fallback team members if database is empty
                $fallback_team = array(
                    array('id' => 1, 'name' => 'rodja man', 'position' => 'Supervisor', 'image' => 'assets/img/team/team-img-1-1.png'),
                    array('id' => 2, 'name' => 'Alexandra Dario', 'position' => 'founder, CEO', 'image' => 'assets/img/team/team-img-1-2.png'),
                    array('id' => 3, 'name' => 'emely jonson', 'position' => 'office cleaner', 'image' => 'assets/img/team/team-img-1-3.png'),
                    array('id' => 4, 'name' => 'erica hanson', 'position' => 'Supervisor', 'image' => 'assets/img/team/team-img-1-4.png'),
                    array('id' => 5, 'name' => 'urica hanson', 'position' => 'Supervisor', 'image' => 'assets/img/team/team-img-1-5.png'),
                    array('id' => 6, 'name' => 'Alexandra Dario', 'position' => 'office cleaner', 'image' => 'assets/img/team/team-img-1-6.png'),
                    array('id' => 7, 'name' => 'axmel Ronson', 'position' => 'Supervisor', 'image' => 'assets/img/team/team-img-1-7.png'),
                    array('id' => 8, 'name' => 'kylie jenner', 'position' => 'Supervisor', 'image' => 'assets/img/team/team-img-1-8.png'),
                );

                // Use database results or fallback
                if ($result && $result->num_rows > 0) {
                    $team_members = array();
                    while ($row = $result->fetch_assoc()) {
                        $team_members[] = $row;
                    }
                } else {
                    $team_members = $fallback_team;
                }

                // Display team members with dynamic delays
                $delay = 0.25;
                foreach ($team_members as $member):
                ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 wow animate__fadeInUp" data-wow-delay="<?php echo $delay; ?>s">
                        <div class="vs-team__style1">
                            <div class="vs-team__img">
                                <a href="team-details.php?id=<?php echo htmlspecialchars($member['id']); ?>">
                                    <img src="<?php echo htmlspecialchars($member['image']); ?>" alt="<?php echo htmlspecialchars($member['name']); ?>">
                                </a>
                                <div class="vs-team__social--media">
                                    <a href="javascript:void(0)"><i class="fab fa-facebook-f"></i></a>
                                    <a href="javascript:void(0)"><i class="fa-brands fa-x-twitter"></i></a>
                                    <a href="javascript:void(0)"><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="vs-team__content">
                                <h2 class="vs-team__title"><a href="team-details.php?id=<?php echo htmlspecialchars($member['id']); ?>"><?php echo htmlspecialchars($member['name']); ?></a></h2>
                                <p class="vs-team__subtitle"><?php echo htmlspecialchars($member['position']); ?></p>
                            </div>
                        </div>
                    </div>
                <?php 
                    $delay += 0.10;
                    endforeach; 
                ?>
                </div>
            </div>
            <span class="shape-mockup" style="right: 0; top: 0px;"><img src="assets/img/shapes/service-shape-1.png" alt="team element"></span>
            <span class="shape-mockup z-index-n1" style="left: 0; bottom: 0px;"><img src="assets/img/shapes/team-shep3.png" alt="team element"></span>
         </section>
    <?php include 'footer.php'; ?>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/slick.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/gsap-scroll-to-plugin.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
</body>

</html>